definition module iostate


//	Version 1.0

/* RWS ---
import	notification
import	commondef, event, processstack, device, receivertable
import	StdTimerDef, StdMenuDef, StdWindowDef, StdControlDef, StdPictureDef, StdReceiverDef
from	roundrobin	import	RR
from	timerhandle	import
			TimerHandles, TimerStateHandle, TimerLSHandle, TimerHandle,
			TimerElementHandle, TimerReceiverHandle, 
			TimerListLSHandle, TimerElimLSHandle, TimerIntroLSHandle, TimerExtendLSHandle, TimerChangeLSHandle
from	menuhandle import
			MenuHandles, MenuStateHandle, MenuLSHandle, MenuHandle,
			MenuElementHandle, MenuItemHandle, MenuReceiverHandle, SubMenuHandle, RadioMenuHandle, MenuSeparatorHandle,
			MenuExtendLSHandle, MenuChangeLSHandle
from	windowhandle import
			DialogHandles, DialogStateHandle, 
			CursorInfo, CursorShape, 
			DialogLSHandle, DialogHandle, 
			WindowMode, Pen, KeyFocus, FocusItem, 
			DElementHandle, DItemHandle, DListLSHandle, DExtendLSHandle, DChangeLSHandle, 
			ControlHandle, 
			WindowKind, IsDialogWindow, IsWindow, 
			ControlKind, IsRadioControl, IsCheckControl, IsPopUpControl, IsSliderControl, 
				IsTextControl, IsEditControl, IsButtonControl, IsCustomButtonControl, 
				IsCustomControl, IsCompoundControl, IsOtherControl, 
			DItemInfo, 
				RadioInfo, RadioItemInfo, CheckInfo, CheckItemInfo, PopUpInfo, SliderInfo, EditInfo, ReceiverInfo, CompoundInfo
from	receiverhandle import
			ReceiverHandles, ReceiverStateHandle, ReceiverHandle,
			MessageEvent, Msg, RHandleFunction, 
			MessageError, ProcessUnknown, ReceiverUnable, ReceiverUnknown
*/
import StdFunc
import devicesystemstate, systemid, receivertable, /*PA+++*/timertable, processstack
import StdIOCommon
import osevent, ostoolbox, osguishare, osactivaterequests
from oswindow import OSWindowPtr
/* ... RWS */
from	ostime import OSTime	// PA+++
from	roundrobin	import	RR

::	*IOSt l p
::	*PSt  l p
	=	{	ls		:: !l									// The local (and private) data of the process
		,	ps		:: !p									// The program state of the process' group
		,	io		:: !*IOSt l p							// The IOSt environment of the process
		}

::	*Groups
	:==	RR *GroupIO
::	*GroupIO
	=	E..p:
		{	groupState	:: !p
		,	groupIO		:: !*Locals p
		}
::	*Locals p
	:==	RR *(LocalIO p)
::	*LocalIO p
	=	E..l:
		{	localState	:: !Maybe l
		,	localIOSt	:: !*IOSt l p
		}

::	RuntimeState
	=	Running												// The process is running
	|	Blocked SystemId									// The process is blocked for the process with given id
	|	Closed												// The process is closed
::	GUIShare
/* RWS ...
	=	{	shareMList	:: !MacMenuHandle					// The handle to the Mac toolbox menu of the top interactive process
		,	shareAppleH	:: !MacMenuHandle					// The handle to the Apple menu of the top interactive process
		}
*/
	:==	OSGUIShare
/* ... RWS */

/* RWS ??? move to device
::	ActivateRequests	:== [NMRecPtr] */
::	ActivateRequests	:== [OSActivateRequest]
::	DoubleDownDist		:== Int
::	KeyTrack			:==	Int								// Message field of the Event of the key being tracked
::	ClipboardState
	=	{	cbsCount	:: Int								// ScrapCount of last access
		}


/* RWS ---
::	DeviceSystemState ps
	= 	TimerSystemState	(TimerHandles		ps)
	|	MenuSystemState		(MenuHandles		ps)
	|	WindowSystemState	(DialogHandles		ps)
	|	ReceiverSystemState	(ReceiverHandles	ps)
--- RWS */

//	Access-rules on the IOSt:

emptyIOSt				:: !SystemId !(Maybe SystemId) !(Maybe GUIShare) !DocumentInterface !ProcessKind 
							![ProcessAttribute (PSt .l .p)] ![IdFun (PSt .l .p)] !(Maybe SystemId)
						-> IOSt .l .p

/* RWS ...
IOStButtonFreq			:: !Int !Point !WindowPtr	!(IOSt .l .p) -> (!Int, !IOSt .l .p)
*/
IOStButtonFreq			:: !Int !Point !OSWindowPtr	!(IOSt .l .p) -> (!Int, !IOSt .l .p)
IOStSetDoubleDownDist	:: !DoubleDownDist			!(IOSt .l .p) -> IOSt .l .p
IOStGetKeyTrack			:: !(IOSt .l .p) -> (Maybe KeyTrack,				!IOSt .l .p)
IOStGetProcessAttributes:: !(IOSt .l .p) -> ([ProcessAttribute (PSt .l .p)],!IOSt .l .p)
IOStGetInitIO			:: !(IOSt .l .p) -> (![IdFun (PSt .l .p)],			!IOSt .l .p)
IOStClosed				:: !(IOSt .l .p) -> (!Bool,							!IOSt .l .p)
IOStGetRuntimeState		:: !(IOSt .l .p) -> (RuntimeState,					!IOSt .l .p)
IOStGetIOIsModal		:: !(IOSt .l .p) -> (Maybe SystemId,				!IOSt .l .p)
IOStGetReceiverTable	:: !(IOSt .l .p) -> (ReceiverTable,					!IOSt .l .p)	/* PA: change of name and type */
IOStGetTimerTable		:: !(IOSt .l .p) -> (TimerTable,					!IOSt .l .p)	/* PA+++ */
IOStGetOSTime			:: !(IOSt .l .p) -> (OSTime,						!IOSt .l .p)	/* PA+++ */
IOStGetActivateRequests	:: !(IOSt .l .p) -> (ActivateRequests,				!IOSt .l .p)
IOStGetEvents			:: !(IOSt .l .p) -> (*OSEvents,						!IOSt .l .p)
IOStGetWorld			:: !(IOSt .l .p) -> (*World,						!IOSt .l .p)
IOStGetLocals			:: !(IOSt .l .p) -> (Locals .p,						!IOSt .l .p)
IOStGetGroups			:: !(IOSt .l .p) -> (Groups,						!IOSt .l .p)
IOStGetProcessStack		:: !(IOSt .l .p) -> (ProcessStack,					!IOSt .l .p)
IOStGetDocumentInterface:: !(IOSt .l .p) -> (DocumentInterface,				!IOSt .l .p)
IOStGetProcessKind		:: !(IOSt .l .p) -> (ProcessKind,					!IOSt .l .p)
IOStGetIOId				:: !(IOSt .l .p) -> (SystemId,						!IOSt .l .p)
IOStGetMaxIONr			:: !(IOSt .l .p) -> (SystemId,						!IOSt .l .p)
IOStNewMaxIONr			:: !(IOSt .l .p) -> (!SystemId,						!IOSt .l .p)
IOStGetParentId			:: !(IOSt .l .p) -> (!Maybe SystemId,				!IOSt .l .p)
IOStGetGUIShare			:: !(IOSt .l .p) -> (!Maybe GUIShare,				!IOSt .l .p)
IOStGetSubProcessIds	:: !(IOSt .l .p) -> ([SystemId],					!IOSt .l .p)
IOStGetIdSeed			:: !(IOSt .l .p) -> (!Int,							!IOSt .l .p)
IOStGetClipboardState	:: !(IOSt .l .p) -> (!ClipboardState,				!IOSt .l .p)

IOStSetKeyTrack			:: !(Maybe KeyTrack)					!(IOSt .l .p) -> IOSt .l .p
IOStSetProcessAttributes:: ![ProcessAttribute (PSt .l .p)]		!(IOSt .l .p) -> IOSt .l .p
IOStSetInitIO			:: ![IdFun (PSt .l .p)]					!(IOSt .l .p) -> IOSt .l .p
IOStSetRuntimeState		:: RuntimeState							!(IOSt .l .p) -> IOSt .l .p
IOStSetIOIsModal		:: !(Maybe SystemId)	 				!(IOSt .l .p) -> IOSt .l .p
IOStSetReceiverTable	:: !ReceiverTable						!(IOSt .l .p) -> IOSt .l .p /* PA: change of name and type */
IOStSetTimerTable		:: !TimerTable							!(IOSt .l .p) -> IOSt .l .p	/* PA+++ */
IOStSetOSTime			:: !OSTime								!(IOSt .l .p) -> IOSt .l .p /* PA+++ */
IOStSetActivateRequests	:: !ActivateRequests					!(IOSt .l .p) -> IOSt .l .p
IOStSetEvents			:: !*OSEvents							!(IOSt .l .p) -> IOSt .l .p
IOStSetWorld			:: !*World								!(IOSt .l .p) -> IOSt .l .p
IOStSetLocals			:: !(Locals .p)							!(IOSt .l .p) -> IOSt .l .p
IOStSetGroups			:: !Groups								!(IOSt .l .p) -> IOSt .l .p
IOStSetProcessStack		:: !ProcessStack						!(IOSt .l .p) -> IOSt .l .p
SelectIOSt				::										!(IOSt .l .p) -> IOSt .l .p
IOStSetMaxIONr			:: !SystemId							!(IOSt .l .p) -> IOSt .l .p
IOStSetGUIShare			:: !(Maybe GUIShare)					!(IOSt .l .p) -> IOSt .l .p
IOStSetSubProcessIds	:: ![SystemId]							!(IOSt .l .p) -> IOSt .l .p
IOStSetIdSeed			:: !Int									!(IOSt .l .p) -> IOSt .l .p
IOStSetClipboardState	:: !ClipboardState						!(IOSt .l .p) -> IOSt .l .p

IOStSwapIO				:: !([*World],!Locals .p,!Groups)		!(IOSt .l .p) -> (!([*World],!Locals .p,!Groups),!IOSt .l .p)

IOStLastInteraction		::										!(IOSt .l .p) -> (!Bool,	!IOSt .l .p)
IOStHasDevice			:: !Device								!(IOSt .l .p) -> (!Bool,	!IOSt .l .p)
IOStGetDevices			::										!(IOSt .l .p) -> (![Device],!IOSt .l .p)

// RWS --- IOStGetAnyDevice		::										!(IOSt .l .p) -> (!DeviceSystemState (PSt .l .p),!IOSt .l .p)
// RWS --- IOStRemoveAnyDevice		::										!(IOSt .l .p) -> (!DeviceSystemState (PSt .l .p),!IOSt .l .p)

IOStGetDevice			:: !Device								!(IOSt .l .p) -> (!DeviceSystemState (PSt .l .p),!IOSt .l .p)
IOStRemoveDevice		:: !Device								!(IOSt .l .p) -> IOSt .l .p
IOStSetDevice			:: !(DeviceSystemState (PSt .l .p))		!(IOSt .l .p) -> IOSt .l .p

// RWS --- toDevice				:: !(DeviceSystemState .ps) -> Device

getIOToolbox			::										!(IOSt .l .p) -> (!*OSToolbox, !IOSt .l .p)
setIOToolbox			:: !*OSToolbox							!(IOSt .l .p) -> IOSt .l .p
appIOToolbox			:: !.(IdFun *OSToolbox)					!(IOSt .l .p) -> IOSt .l .p
accIOToolbox			:: !.(St *OSToolbox .x)					!(IOSt .l .p) -> (!.x, !IOSt .l .p)
